/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.services.Service;
import com.sap.cds.services.runtime.CdsRuntime;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;

public class ServiceBeanFactory
implements FactoryBean<Service>,
BeanFactoryAware {
    private final String serviceName;
    private final Class<?> serviceClass;
    private BeanFactory beanFactory;
    private Service service;

    public ServiceBeanFactory(String serviceName, Class<?> serviceClass) {
        this.serviceName = serviceName;
        this.serviceClass = serviceClass;
    }

    public Service getObject() {
        if (this.service == null) {
            CdsRuntime runtime = (CdsRuntime)this.beanFactory.getBean(CdsRuntime.class);
            this.service = runtime.getServiceCatalog().getService(this.serviceName);
        }
        return this.service;
    }

    public Class<?> getObjectType() {
        return this.serviceClass == null ? Service.class : this.serviceClass;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

