/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.environment.PropertiesProvider;
import com.sap.cds.services.utils.StringUtils;
import java.util.Map;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;

public class SpringPropertiesProvider
implements PropertiesProvider {
    static String CDS_ENVIRONMENT_PRODUCTION_ENABLED = "cds.environment.production.enabled";
    static String CDS_ENVIRONMENT_PRODUCTION_PROFILE = "cds.environment.production.profile";
    private final Environment environment;

    public SpringPropertiesProvider(Environment environment) {
        this.environment = environment;
    }

    public <T> T bindPropertyClass(String section, Class<T> clazz) {
        Bindable bindable = clazz.equals(CdsProperties.class) && this.isProduction() ? Bindable.ofInstance((Object)this.withProductionDefaults()) : Bindable.of(clazz);
        BindResult bindResult = Binder.get((Environment)this.environment).bind(section, bindable);
        if (bindResult.isBound()) {
            return (T)bindResult.get();
        }
        if (bindable.getValue() != null) {
            return bindable.getValue().get();
        }
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private boolean isProduction() {
        if (this.environment.containsProperty(CDS_ENVIRONMENT_PRODUCTION_ENABLED)) {
            return (Boolean)this.environment.getProperty(CDS_ENVIRONMENT_PRODUCTION_ENABLED, Boolean.class);
        }
        String productionProfile = this.environment.getProperty(CDS_ENVIRONMENT_PRODUCTION_PROFILE);
        if (!StringUtils.isEmpty((String)productionProfile)) {
            return this.environment.matchesProfiles(new String[]{productionProfile});
        }
        return false;
    }

    private CdsProperties withProductionDefaults() {
        CdsProperties cds = new CdsProperties();
        cds.getEnvironment().getProduction().setEnabled(Boolean.valueOf(true));
        cds.getIndexPage().setEnabled(Boolean.valueOf(false));
        cds.getSecurity().getMock().setEnabled(Boolean.valueOf(false));
        return cds;
    }

    public String getProperty(String key, String defaultValue) {
        return this.environment.getProperty(key, defaultValue);
    }

    public <T> T getProperty(String key, Class<T> clazz, T defaultValue) {
        if (Map.class.isAssignableFrom(clazz)) {
            return this.bindPropertyClass(key, clazz);
        }
        return (T)this.environment.getProperty(key, clazz, defaultValue);
    }
}

