/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth.mock;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.framework.spring.config.auth.HttpSecurityConfigurer;
import com.sap.cds.framework.spring.config.auth.identity.IdentitySecurityConfig;
import com.sap.cds.framework.spring.config.auth.mock.MockUsersConfiguredCondition;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.provisioning.InMemoryUserDetailsManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.www.BasicAuthenticationEntryPoint;

@AutoConfiguration(after={IdentitySecurityConfig.class})
@ConditionalOnClass(value={HttpSecurity.class})
@ConditionalOnMissingBean(value={IdentitySecurityConfig.class})
@Conditional(value={MockUsersConfiguredCondition.class})
@ConditionalOnWebApplication
@EnableWebSecurity
@Order(value=1000)
public class MockUsersSecurityConfig {
    private static final Logger logger = LoggerFactory.getLogger(MockUsersSecurityConfig.class);
    private static final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    @Autowired
    private HttpSecurityConfigurer httpSecurityConfigurer;
    @Autowired
    private CdsRuntime runtime;

    @Bean
    public SecurityFilterChain mockFilterChain(HttpSecurity http) throws Exception {
        this.httpSecurityConfigurer.configure(http);
        http.httpBasic(c -> {
            BasicAuthenticationEntryPoint entryPoint = new BasicAuthenticationEntryPoint();
            entryPoint.setRealmName("Realm");
            entryPoint.afterPropertiesSet();
            c.authenticationEntryPoint((AuthenticationEntryPoint)entryPoint);
        });
        Collection<CdsProperties.Security.Mock.User> users = this.runtime.getEnvironment().getCdsProperties().getSecurity().getMock().getUsers().values();
        if (users.isEmpty()) {
            logger.warn("No mock users found in configuration. Spring standard authentication manager with default user 'user' (password written to console) is available");
        } else {
            http.authenticationProvider((AuthenticationProvider)this.buildAuthenticationProvider(users));
        }
        http.csrf(c -> c.disable());
        http.headers(h -> h.frameOptions(fo -> fo.disable()));
        logger.info("*************************************************************************");
        logger.info("*  Security configuration based on mock users found in active profile.  *");
        logger.info("*                 !!! NEVER USE IN PRODUCTIVE MODE !!!                  *");
        logger.info("*************************************************************************");
        return (SecurityFilterChain)http.build();
    }

    private DaoAuthenticationProvider buildAuthenticationProvider(Collection<CdsProperties.Security.Mock.User> users) {
        ArrayList<UserDetails> userDetails = new ArrayList<UserDetails>();
        for (CdsProperties.Security.Mock.User user : users) {
            if (!user.isValid()) {
                logger.warn("Skipping invalid mock user defintion {} ('name' and 'password' required)", (Object)this.stringifyUser(user));
                continue;
            }
            userDetails.add(User.builder().username(user.getName()).password("{noop}" + user.getPassword()).authorities(user.getRoles().toArray(new String[0])).build());
            logger.info("Added mock user {}", (Object)this.stringifyUser(user));
        }
        InMemoryUserDetailsManager userDetailsService = new InMemoryUserDetailsManager(userDetails);
        DaoAuthenticationProvider authenticationProvider = new DaoAuthenticationProvider();
        authenticationProvider.setUserDetailsService((UserDetailsService)userDetailsService);
        return authenticationProvider;
    }

    private String stringifyUser(CdsProperties.Security.Mock.User user) {
        try {
            return mapper.writeValueAsString((Object)user);
        }
        catch (Exception e) {
            return user.getName();
        }
    }
}

