/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.CdsDataStore;
import com.sap.cds.framework.spring.config.datasource.PlatformTransactionManagerPostProcessor;
import com.sap.cds.framework.spring.config.datasource.SpringTransactionManager;
import com.sap.cds.framework.spring.utils.ProxyUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.impl.persistence.JdbcPersistenceService;
import com.sap.cds.services.impl.persistence.JdbcPersistenceServiceConfiguration;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import com.sap.cds.services.transaction.TransactionManager;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceTransactionManagerAutoConfiguration;
import org.springframework.boot.jdbc.EmbeddedDatabaseConnection;
import org.springframework.boot.sql.init.dependency.DependsOnDatabaseInitialization;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.datasource.TransactionAwareDataSourceProxy;
import org.springframework.transaction.PlatformTransactionManager;

@AutoConfiguration(after={DataSourceAutoConfiguration.class, DataSourceTransactionManagerAutoConfiguration.class})
@ConditionalOnClass(value={JdbcPersistenceServiceConfiguration.class, TransactionAwareDataSourceProxy.class})
@ConditionalOnBean(value={DataSource.class, PlatformTransactionManager.class})
@DependsOnDatabaseInitialization
@ImportRuntimeHints(value={SpringJdbcPersistenceServiceRuntimeHints.class})
public class SpringJdbcPersistenceServiceConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SpringJdbcPersistenceServiceConfiguration.class);
    private final JdbcPersistenceServiceConfiguration configuration;

    public static JdbcPersistenceServiceConfiguration createJdbcPersistenceServiceConfiguration(String serviceName, DataSource dataSource, PlatformTransactionManager platformTransactionManager) {
        SpringTransactionManager txMgr = ((PlatformTransactionManagerPostProcessor.SpringTransactionManagerGetter)platformTransactionManager).getSpringTransactionManager(serviceName);
        TransactionAwareDataSourceProxy txAwareDataSource = new TransactionAwareDataSourceProxy(dataSource);
        Supplier<Connection> connectionSupplier = () -> SpringJdbcPersistenceServiceConfiguration.lambda$createJdbcPersistenceServiceConfiguration$0((DataSource)txAwareDataSource);
        return JdbcPersistenceServiceConfiguration.create((String)serviceName, connectionSupplier, (TransactionManager)txMgr);
    }

    public SpringJdbcPersistenceServiceConfiguration(DataSource dataSource, PlatformTransactionManager platformTransactionManager, CdsRuntime runtime) {
        PlatformTransactionManager originalPlatformTransactionManager;
        String csvInitMode = runtime.getEnvironment().getCdsProperties().getDataSource().getCsv().getInitializationMode();
        if ("embedded".equals(csvInitMode) && this.isEmbedded(dataSource)) {
            logger.debug("Determined DataSource as embedded based on connection check.");
            runtime.getEnvironment().getCdsProperties().getDataSource().setEmbedded(true);
        }
        if ((originalPlatformTransactionManager = ((PlatformTransactionManagerPostProcessor.SpringTransactionManagerGetter)platformTransactionManager).getPlatformTransactionManager()) instanceof DataSourceTransactionManager) {
            DataSourceTransactionManager dataSourceTransactionManager = (DataSourceTransactionManager)originalPlatformTransactionManager;
            if (dataSourceTransactionManager.getDataSource() != dataSource) {
                logger.warn("DataSource managed by primary DataSourceTransactionManager does not match primary DataSource");
            }
        } else {
            logger.warn("Primary PlatformTransactionManager is not a DataSourceTransactionManager but has type '{}'", originalPlatformTransactionManager.getClass());
        }
        this.configuration = SpringJdbcPersistenceServiceConfiguration.createJdbcPersistenceServiceConfiguration("PersistenceService$Default", dataSource, platformTransactionManager);
    }

    @Primary
    @Bean(value={"PersistenceService$Default"})
    public JdbcPersistenceService persistenceService(CdsRuntimeConfigurer configurer) {
        return this.configuration.createOrGetService(configurer);
    }

    @Bean
    public CdsDataStore cdsDataStore(CdsRuntimeConfigurer configurer) {
        JdbcPersistenceService persistenceService = this.configuration.createOrGetService(configurer);
        return ProxyUtils.createProxy(CdsDataStore.class, () -> persistenceService.getCdsDataStore());
    }

    private boolean isEmbedded(DataSource dataSource) {
        try {
            return EmbeddedDatabaseConnection.isEmbedded((DataSource)dataSource);
        }
        catch (Exception e) {
            return false;
        }
    }

    private static /* synthetic */ Connection lambda$createJdbcPersistenceServiceConfiguration$0(DataSource txAwareDataSource) {
        try {
            return txAwareDataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.JDBC_CONNECTION_FAILED, new Object[]{e});
        }
    }

    static class SpringJdbcPersistenceServiceRuntimeHints
    implements RuntimeHintsRegistrar {
        SpringJdbcPersistenceServiceRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            hints.proxies().registerJdkProxy(new Class[]{CdsDataStore.class});
        }
    }
}

