package com.sap.cds.framework.spring.config.ui;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

import com.sap.cds.adapter.IndexContentProvider;
import com.sap.cds.adapter.IndexContentProviderFactory;

public class StaticUiIndexContentProviderFactory implements IndexContentProviderFactory {

	@Override
	public IndexContentProvider create() {
		return new UiIndexContentProvider(StaticUiCondition.getAppFolder());
	}

	@Override
	public boolean isEnabled() {
		return StaticUiCondition.hasAppFolder();
	}

	private static class UiIndexContentProvider implements IndexContentProvider {

		private static final String ENDPOINT_START = """
		                <ul>
		""";

		private static final String ENDPOINT = """
		                    <li>
		                        <a href="%s"><span>%s</span></a>
		                    </li>
		""";

		private static final String ENDPOINT_END = """
		                </ul>
		""";

		private static final String NONE = """
		                    <li>
		                        <span> — none — </span>
		                    </li>
		""";

		private static final Set<String> excludes = Set.of("node_modules", "dist");
		private final List<String> pages = new ArrayList<>();

		public UiIndexContentProvider(String app) {
			findHtmlPages(new File(app), "", 0);
			Collections.sort(pages, (p1, p2) -> {
				int s = Integer.compare(countSegments(p1), countSegments(p2));
				return s == 0 ? p1.compareTo(p2) : s;
			});
		}

		private void findHtmlPages(File folder, String prefix, int depth) {
			for (File file : folder.listFiles()) {
				if (file.isFile() && file.getName().endsWith(".html")) {
					pages.add(prefix + file.getName());
				}

				if (depth < 2 && file.isDirectory() && !excludes.contains(file.getName())) {
					findHtmlPages(file, prefix + file.getName() + "/", depth + 1);
				}
			}
		}

		private static int countSegments(String path) {
			int count = 0;
			for(char c : path.toCharArray()) {
				if (c == '/') {
					++count;
				}
			}
			return count;
		}

		@Override
		public String getSectionTitle() {
			return "Web Applications";
		}

		@Override
		public void writeContent(PrintWriter writer, String contextPath) {
			writer.print(ENDPOINT_START);
			if (pages.isEmpty()) {
				writer.print(NONE);
			} else {
				for (String page : pages) {
					writer.printf(ENDPOINT, contextPath + "/" + page, "/" + page.replace("/index.html", ""));
				}
			}
			writer.print(ENDPOINT_END);
		}

		@Override
		public int order() {
			return -100;
		}

	}

}
