/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth.identity;

import com.sap.cds.framework.spring.config.auth.HttpSecurityConfigurer;
import com.sap.cds.framework.spring.config.auth.identity.IdentityConfiguredCondition;
import com.sap.cds.framework.spring.config.auth.identity.IdentityFeature;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.IdentityUtils;
import com.sap.cloud.security.spring.config.IdentityServiceConfiguration;
import com.sap.cloud.security.spring.config.IdentityServicesPropertySourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.annotation.Order;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.web.SecurityFilterChain;

@AutoConfiguration
@ConditionalOnClass(value={IdentityServiceConfiguration.class, HttpSecurity.class, Jwt.class})
@Conditional(value={IdentityConfiguredCondition.class})
@PropertySource(factory=IdentityServicesPropertySourceFactory.class, value={""})
@ConditionalOnWebApplication
@EnableWebSecurity
@Order(value=1000)
public class IdentitySecurityConfig {
    private static final Logger logger = LoggerFactory.getLogger(IdentitySecurityConfig.class);
    @Autowired
    private CdsRuntime runtime;
    @Autowired
    private HttpSecurityConfigurer httpSecurityConfigurer;
    @Autowired
    private IdentityFeature identityFeatue;
    @Autowired(required=false)
    private Converter<Jwt, AbstractAuthenticationToken> authConverter;

    @Bean
    public SecurityFilterChain identityFilterChain(HttpSecurity http) throws Exception {
        if (!this.identityFeatue.isActive()) {
            throw new IllegalStateException("Identity configuration requires dependency to cds-feature-identity. Alternatively, deactivate this security configuration with property 'cds.security.identity.enabled: false' AND provide your own configuration.");
        }
        IdentityUtils.AuthenticationType authType = new IdentityUtils(this.runtime).configuredAuthenticationType();
        http.sessionManagement(s -> s.sessionCreationPolicy(SessionCreationPolicy.STATELESS));
        this.httpSecurityConfigurer.configure(http);
        http.oauth2ResourceServer(resourceServer -> resourceServer.jwt(jwtConfigurer -> {
            if (this.authConverter != null) {
                jwtConfigurer.jwtAuthenticationConverter(this.authConverter);
            }
        }));
        switch (authType) {
            case XSUAA: {
                if (this.authConverter == null) {
                    throw new IllegalStateException("Identity configuration for XSUAA requires Converter<Jwt, AbstractAuthenticationToken>");
                }
                logger.info("Activated identity security configuration based on XSUAA");
                break;
            }
            case IAS: {
                logger.info("Activated identity security configuration based on IAS");
                break;
            }
            case IAS_XSUAA: {
                if (this.authConverter == null) {
                    throw new IllegalStateException("Identity configuration for XSUAA requires Converter<Jwt, AbstractAuthenticationToken>");
                }
                logger.info("Activated identity security configuration based on IAS and XSUAA");
                break;
            }
            default: {
                throw new IllegalStateException("Configuration error: Can't configure authentication without a unique binding to either XSUAA or IAS service");
            }
        }
        return (SecurityFilterChain)http.build();
    }
}

