/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.adapter;

import com.sap.cds.adapter.AdapterFactory;
import com.sap.cds.adapter.ServletAdapterFactory;
import com.sap.cds.framework.spring.config.adapter.ServletAdapterRestController;
import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import jakarta.servlet.Servlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartFactoryBean;

public class AdapterBeanFactory
implements SmartFactoryBean<Object>,
BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(AdapterBeanFactory.class);
    private final String factoryName;
    private BeanFactory beanFactory;
    private Object adapter;

    public AdapterBeanFactory(String factoryName) {
        this.factoryName = factoryName;
    }

    public Object getObject() throws Exception {
        if (this.adapter == null) {
            BootstrapCache bootstrapCache = (BootstrapCache)this.beanFactory.getBean(BootstrapCache.class);
            AdapterFactory factory = bootstrapCache.getAdapterFactories().get(this.factoryName);
            if (factory instanceof ServletAdapterFactory) {
                ServletAdapterFactory servletFactory = (ServletAdapterFactory)factory;
                Servlet servlet = (Servlet)servletFactory.create();
                String servletName = servlet.getClass().getSimpleName();
                String basePath = servletFactory.getBasePath();
                this.adapter = new ServletAdapterRestController(servlet, basePath);
                logger.info("Servlet {} mapped to {}", (Object)servletName, (Object)basePath);
            } else {
                this.adapter = factory.create();
                logger.info("Adapter {} initialized", (Object)this.adapter.getClass().getSimpleName());
            }
        }
        return this.adapter;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Class<?> getObjectType() {
        return Object.class;
    }

    public boolean isEagerInit() {
        return true;
    }
}

