/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@AutoConfiguration
@ConditionalOnClass(value={HttpSecurity.class})
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="management.endpoint.health.probes", name={"enabled"}, havingValue="true")
@EnableWebSecurity
@Order(value=100)
public class HealthProbesSecurityConfig {
    private static final Logger logger = LoggerFactory.getLogger(HealthProbesSecurityConfig.class);
    private final Environment env;

    public HealthProbesSecurityConfig(Environment env) {
        this.env = env;
    }

    @Bean
    public SecurityFilterChain appFilterChain(HttpSecurity http) throws Exception {
        String basePath = this.env.getProperty("management.endpoints.web.base-path", "/actuator");
        String readinessPath = "%s/health/readiness".formatted(basePath);
        String livenessPath = "%s/health/liveness".formatted(basePath);
        logger.debug("Opening endpoints for health probes {} and {}.", (Object)readinessPath, (Object)livenessPath);
        return (SecurityFilterChain)http.securityMatcher((RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)readinessPath), AntPathRequestMatcher.antMatcher((String)livenessPath)})).csrf(c -> c.disable()).authorizeHttpRequests(r -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)r.anyRequest()).permitAll()).build();
    }
}

