/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.bind.BindableRuntimeHintsRegistrar;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.env.Environment;

@AutoConfiguration
@ImportRuntimeHints(value={CdsRuntimeRuntimeHints.class})
public class CdsRuntimeBeanConfig {
    private final BootstrapCache bootstrapCache;

    public CdsRuntimeBeanConfig(Environment environment) {
        this.bootstrapCache = BootstrapCache.get(environment).ensureServices();
    }

    @Bean
    public BootstrapCache bootstrapCache() {
        return this.bootstrapCache;
    }

    @Bean
    public CdsRuntimeConfigurer cdsRuntimeConfigurer() {
        return this.bootstrapCache.getConfigurer();
    }

    @Bean
    public CdsRuntime cdsRuntime() {
        return this.bootstrapCache.getCdsRuntime();
    }

    static class CdsRuntimeRuntimeHints
    implements RuntimeHintsRegistrar {
        CdsRuntimeRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
            BindableRuntimeHintsRegistrar.forTypes((Class[])new Class[]{CdsProperties.class, CdsProperties.Enabled.class, CdsProperties.ConnectionPool.class, CdsProperties.Servlet.class}).registerHints(hints);
            hints.reflection().registerType(CdsProperties.Servlet.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
            hints.reflection().registerType(CdsProperties.Remote.RemoteServiceConfig.Destination.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
        }
    }
}

