/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth.identity;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.IdentityUtils;
import com.sap.cds.services.utils.environment.ServiceBindingUtils;
import com.sap.cloud.environment.servicebinding.api.ServiceBinding;
import com.sap.cloud.security.config.Environments;
import com.sap.cloud.security.config.ServiceBindingEnvironment;
import com.sap.cloud.security.spring.config.IdentityServiceConfiguration;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;

public class IdentityEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(IdentityEnvironmentPostProcessor.class);
    private static final String PROPERTYSOURCE_NAME = "cds-identity";
    private static final String PARAM_PROOF_TOKEN = "sap.spring.security.identity.prooftoken";
    private static boolean identityLibraryAvailable;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        List xsuaaBindings;
        if (!identityLibraryAvailable) {
            return;
        }
        CdsRuntime runtime = BootstrapCache.get((Environment)environment).getCdsRuntime();
        IdentityUtils identityUtils = new IdentityUtils(runtime);
        List identityBindings = identityUtils.getIasServiceBindings();
        if (identityBindings.size() > 1) {
            logger.warn("Multiple service bindings with tag 'identity' found");
        }
        ArrayList<ServiceBinding> bindings = new ArrayList<ServiceBinding>();
        if (!identityBindings.isEmpty()) {
            bindings.add((ServiceBinding)identityBindings.get(0));
            if (!environment.containsProperty(PARAM_PROOF_TOKEN)) {
                environment.getPropertySources().addLast(this.createPropertySource(runtime));
            }
        }
        if ((xsuaaBindings = identityUtils.getXsuaaServiceBindings()).size() > 1) {
            logger.warn("Multiple service bindings with tag 'xsuaa' found");
        }
        if (runtime.getEnvironment().getCdsProperties().getSecurity().getXsuaa().isAllowMultipleBindings()) {
            bindings.addAll(runtime.getEnvironment().getServiceBindings().filter(b -> ServiceBindingUtils.matches((ServiceBinding)b, (String)"xsuaa")).collect(Collectors.toList()));
        } else if (!xsuaaBindings.isEmpty()) {
            bindings.add((ServiceBinding)xsuaaBindings.get(0));
        }
        bindings.forEach(b -> logger.info("Using service binding '{}' to configure identity authentication", b.getName().get()));
        ServiceBindingEnvironment env = new ServiceBindingEnvironment(() -> bindings);
        try {
            Field field = Environments.class.getDeclaredField("currentEnvironment");
            field.setAccessible(true);
            field.set(null, env);
        }
        catch (Exception e) {
            throw new InternalError("Missing field com.sap.cloud.security.config.Environments.currentEnvironment", e);
        }
    }

    private PropertySource<?> createPropertySource(CdsRuntime runtime) {
        Properties props = new Properties();
        props.put(PARAM_PROOF_TOKEN, (Object)true);
        return new PropertiesPropertySource(PROPERTYSOURCE_NAME, props);
    }

    static {
        try {
            identityLibraryAvailable = IdentityServiceConfiguration.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            identityLibraryAvailable = false;
        }
    }
}

