/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.actuator;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.mt.runtime.DbHealthIndicatorImpl;
import com.sap.cloud.mt.runtime.TenantAwareDataSource;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public class TenantAwareDataSourceHealthIndicator
implements HealthIndicator {
    private final DbHealthIndicatorImpl<Health> dbHealthIndicator;

    public TenantAwareDataSourceHealthIndicator(TenantAwareDataSource dataSource, CdsRuntime runtime) {
        long intervallMillis = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getHealthCheck().getInterval().toMillis();
        String healthCheckStatement = runtime.getEnvironment().getCdsProperties().getMultiTenancy().getHealthCheck().getHealthCheckStatement();
        this.dbHealthIndicator = new DbHealthIndicatorImpl(healthCheckStatement, dataSource, Long.valueOf(intervallMillis), () -> Health.up().build(), (text, details) -> Health.down().withDetail(text, (Object)details).build(), (text, details) -> Health.up().withDetail(text, (Object)details).build());
    }

    public Health health() {
        return (Health)this.dbHealthIndicator.health();
    }
}

