/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.datasource;

import com.sap.cds.services.transaction.TransactionManager;
import java.util.Stack;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionManager
implements TransactionManager {
    private final String name;
    private final PlatformTransactionManager txMgr;
    private final ThreadLocal<Stack<TransactionStatus>> transactions = ThreadLocal.withInitial(() -> new Stack());

    public SpringTransactionManager(String name, PlatformTransactionManager txMgr) {
        this.name = name;
        this.txMgr = txMgr;
    }

    public boolean isActive() {
        return TransactionSynchronizationManager.isActualTransactionActive();
    }

    public void begin() {
        this.begin((TransactionDefinition)new DefaultTransactionDefinition(3));
    }

    void begin(TransactionDefinition definition) {
        TransactionStatus tx = null;
        try {
            tx = this.txMgr.getTransaction(definition);
        }
        finally {
            this.transactions.get().push(tx);
        }
    }

    public void commit() {
        TransactionStatus tx = this.transactions.get().pop();
        if (tx != null) {
            this.txMgr.commit(tx);
        }
    }

    public void rollback() {
        TransactionStatus tx = this.transactions.get().pop();
        if (tx != null) {
            this.txMgr.rollback(tx);
        }
    }

    public boolean isRollbackOnly() {
        TransactionStatus tx = this.transactions.get().peek();
        if (tx != null) {
            return tx.isRollbackOnly();
        }
        return true;
    }

    public void setRollbackOnly() {
        TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
    }

    public String getName() {
        return this.name;
    }
}

