/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.runtime;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.bind.BindableRuntimeHintsRegistrar;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.core.env.Environment;

import com.sap.cds.framework.spring.config.runtime.CdsRuntimeBeanConfig.CdsRuntimeRuntimeHints;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

@AutoConfiguration
@ImportRuntimeHints(CdsRuntimeRuntimeHints.class)
public class CdsRuntimeBeanConfig {

	static class CdsRuntimeRuntimeHints implements RuntimeHintsRegistrar {

		@Override
		public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
			// CdsProperties
			BindableRuntimeHintsRegistrar.forTypes(
					CdsProperties.class,
					CdsProperties.Enabled.class, CdsProperties.ConnectionPool.class, CdsProperties.Servlet.class
			).registerHints(hints);
			hints.reflection().registerType(CdsProperties.Servlet.class, MemberCategory.INVOKE_PUBLIC_METHODS);
			hints.reflection().registerType(CdsProperties.Remote.RemoteServiceConfig.Destination.class, MemberCategory.INVOKE_PUBLIC_METHODS);
		}

	}

	private final BootstrapCache bootstrapCache;

	public CdsRuntimeBeanConfig(Environment environment) {
		bootstrapCache = BootstrapCache.get(environment).ensureServices();
	}

	@Bean
	public BootstrapCache bootstrapCache() {
		return bootstrapCache;
	}

	@Bean
	public CdsRuntimeConfigurer cdsRuntimeConfigurer() {
		return bootstrapCache.getConfigurer();
	}

	@Bean
	public CdsRuntime cdsRuntime() {
		return bootstrapCache.getCdsRuntime();
	}

}
