package com.sap.cds.framework.spring.config.ui;

import java.io.File;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.runtime.CdsRuntime;

class StaticUiCondition implements Condition {

	private static String[] uiLocations = {"app", "../app"};

	static boolean hasAppFolder() {
		return getAppFolder() != null;
	}

	static String getAppFolder() {
		for (String uiLocation : uiLocations) {
			File folder = new File(uiLocation);
			if(folder.exists() && folder.isDirectory()) {
				return uiLocation;
			}
		}
		return null;
	}

	@Override
	public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
		CdsRuntime runtime = BootstrapCache.get(context.getEnvironment()).getCdsRuntime();
		return runtime.getEnvironment().getCdsProperties().getIndexPage().isEnabled() && hasAppFolder();
	}

}
