/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.actuator;

import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.sdk.cloudplatform.connectivity.DestinationAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpClientAccessor;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import java.time.Duration;
import java.time.Instant;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

class DestinationBasedHealthIndicator
implements HealthIndicator {
    private static final Duration TIMEOUT_DURATION = Duration.ofSeconds(1L);
    private static final Duration STATUS_TIME_TO_LIVE = Duration.ofSeconds(10L);
    private final CdsRuntime runtime;
    private final String destinationName;
    private HttpClient httpClient;
    private Health lastHealth;
    private Instant lastCheckedAt;
    private final ResilienceConfiguration resilienceConfiguration;

    DestinationBasedHealthIndicator(CdsRuntime runtime, String destinationName) {
        this.runtime = runtime;
        this.destinationName = destinationName;
        this.resilienceConfiguration = ResilienceConfiguration.of((String)(destinationName + ".health")).timeLimiterConfiguration(ResilienceConfiguration.TimeLimiterConfiguration.of((Duration)TIMEOUT_DURATION));
    }

    public Health health() {
        if (this.httpClient == null) {
            this.httpClient = HttpClientAccessor.getHttpClient((HttpDestinationProperties)DestinationAccessor.getDestination((String)this.destinationName).asHttp());
        }
        Instant now = Instant.now();
        if (this.lastCheckedAt == null || this.lastCheckedAt.plus(STATUS_TIME_TO_LIVE).isBefore(now)) {
            this.lastCheckedAt = now;
            this.lastHealth = (Health)this.runtime.requestContext().systemUserProvider().run(r -> {
                try {
                    return (Health)ResilienceDecorator.executeCallable(() -> {
                        HttpResponse response = this.httpClient.execute((HttpUriRequest)new HttpGet("/health"));
                        EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                        if (200 == response.getStatusLine().getStatusCode()) {
                            return Health.up().build();
                        }
                        return Health.down().build();
                    }, (ResilienceConfiguration)this.resilienceConfiguration);
                }
                catch (Exception e) {
                    return Health.down().build();
                }
            });
        }
        return this.lastHealth;
    }
}

