/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.actuator;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

import com.sap.cds.services.utils.info.CdsInfo;
import com.zaxxer.hikari.HikariPoolMXBean;

public class CdsDbPoolsInfo implements CdsInfo {

	@Override
	public String name() {
		return "dbpools";
	}

	@Override
	public Object info(Details details) {
		Map<String, Object> info = new LinkedHashMap<>();

		MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
		Set<ObjectName> names;
		try {
			names = mBeanServer.queryNames(new ObjectName("com.zaxxer.hikari:type=Pool (*)"), null);
		} catch (MalformedObjectNameException e) {
			names = Collections.emptySet();
		}
		for (ObjectName name : names) {
			String poolName = name.getCanonicalName().substring(29, name.getCanonicalName().length() - 1);
			HikariPoolMXBean pool = JMX.newMXBeanProxy(mBeanServer, name, HikariPoolMXBean.class);
			Map<String, Object> props = new LinkedHashMap<>();
			try {
				// optionally try to parse tenantId and databaseId
				props.put("tenantId", poolName.substring(11, poolName.indexOf("#")));
				props.put("databaseId", poolName.substring(poolName.indexOf("#") + 1, poolName.length()));
			} catch (IndexOutOfBoundsException e) {
				// ignore
			}
			props.put("active", pool.getActiveConnections());
			props.put("idle", pool.getIdleConnections());
			props.put("total", pool.getTotalConnections());
			props.put("threadsAwaiting", pool.getThreadsAwaitingConnection());
			info.put(poolName, props);
		}

		return info;
	}


}
