/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth.identity;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

import com.sap.cds.feature.identity.IdentityUserInfoProvider;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.IdentityUtils;

@AutoConfiguration(before = DefaultIdentityFeatureConfig.class)
@ConditionalOnClass(IdentityUserInfoProvider.class) // optionally loaded with cds-feature-identity
public class LoadedIdentityFeatureConfig {

	@Bean
	public IdentityFeature identityFeature(CdsRuntime runtime) {
		IdentityUtils identityUtils = new IdentityUtils(runtime);
		return () -> identityUtils.configuredAuthenticationType() != null;
	}

}
