/*********************************************************************
 * (C) 2024 SAP SE or an SAP affiliate company. All rights reserved. *
 *********************************************************************/
package com.sap.cds.framework.spring.actuator;

import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

import com.sap.cds.feature.mt.RoutingDataSourceFactory;
import com.sap.cds.framework.spring.config.runtime.CdsRuntimeBeanDefinitionRegistrar;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.feature.mt.lib.subscription.ProvisioningService;

@AutoConfiguration(after = { CdsRuntimeBeanDefinitionRegistrar.class })
@ConditionalOnClass({HealthIndicator.class, RoutingDataSourceFactory.class})
// Standard Spring ConditionalOnEnabledHealthIndicator fallbacks to defaults. We do not want that here
@ConditionalOnProperty(prefix = "management.health", value = "deploymentService.enabled")
@Conditional(DeploymentServiceEnabledCondition.class)
public class DeploymentServiceHealthIndicatorConfiguration {

	@Bean
	public HealthIndicator deploymentServiceHealthIndicator(CdsRuntime runtime) {
		return new DestinationBasedHealthIndicator(runtime, ProvisioningService.MTX_PROVISIONING_SERVICE_DESTINATION);
	}

}
