/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth.identity;

import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.IdentityUtils;

/**
 * A {@link Condition} that helps to decide if Identity is configured or not.
 */
public class IdentityConfiguredCondition implements Condition {

	@Override
	public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
		CdsRuntime runtime = BootstrapCache.get(context.getEnvironment()).getCdsRuntime();
		return new IdentityUtils(runtime).configuredAuthenticationType() != null &&
				runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().getAuthConfig().isEnabled();
	}

}
