package com.sap.cds.framework.spring.config.ui;

import java.nio.file.Path;

import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.PathResource;
import org.springframework.core.io.Resource;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@ConditionalOnWebApplication
@ConditionalOnClass(WebMvcConfigurer.class)
@Conditional(StaticUiCondition.class)
@Order(-100) // higher priority than WebMvcAutoConfigurationAdapter
public class StaticUiResourceConfig implements WebMvcConfigurer {

	@Override
	public void addResourceHandlers(ResourceHandlerRegistry registry) {
		if (registry.hasMappingForPattern("/**")) {
			return; // honor existing mapping from custom code
		}
		Resource app = new PathResource(Path.of(StaticUiCondition.getAppFolder()).toAbsolutePath());
		registry.addResourceHandler("/**").addResourceLocations(app);
	}

}
