/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.utils;

import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.ComponentScan;

/**
 * Class providing a main method to unsubscribe the tenant.
 * This main method starts the whole server. Therefore, all background tasks that might be registered will also start.
 * If this could lead to problems, they need to be deactivated.
 */
@SpringBootApplication
@ComponentScan(basePackages = "${cds.multitenancy.component-scan:acme.xyy}")
public class Unsubscribe {

	private static final Logger logger = LoggerFactory.getLogger(Unsubscribe.class);

	public static void main(String[] args) throws Exception {
		System.exit(MtCommand.execute(Unsubscribe.class, (deploymentService, runtime, startTime) -> {
			String tenant = MtCommand.getTenant(args);
			Map<String, Object> options = MtCommand.getOptions(args, true);
			logger.info("Starting unsubscribe for tenant '{}'", tenant);
			deploymentService.unsubscribe(tenant, options);
			logger.info("Unsubscribe finished successfully in {}s", (System.currentTimeMillis() - startTime) / 1000);
		}));
	}
}
