/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class CdsLoggerGroupsPostProcessor
implements EnvironmentPostProcessor {
    private static final String CDS_DEFAULT_PROPERTIES_SOURCE_NAME = "cds-loggers";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        TreeMap<String, List> loggerMap = new TreeMap<String, List>();
        for (CdsLoggerGroups loggerGroups : CdsLoggerGroups.values()) {
            String[] loggers = loggerGroups.loggers();
            for (String loggerGroup : loggerGroups.loggerGroups()) {
                ArrayList<String> loggerGroupLoggers = (ArrayList<String>)loggerMap.get(loggerGroup);
                if (loggerGroupLoggers == null) {
                    loggerGroupLoggers = new ArrayList<String>();
                    loggerMap.put(loggerGroup, loggerGroupLoggers);
                }
                loggerGroupLoggers.addAll(Arrays.asList(loggers));
            }
        }
        TreeMap propertyMap = new TreeMap();
        loggerMap.forEach((k, v) -> propertyMap.put(k, v.stream().collect(Collectors.joining(","))));
        environment.getPropertySources().addLast((PropertySource)new MapPropertySource(CDS_DEFAULT_PROPERTIES_SOURCE_NAME, propertyMap));
    }

    private static enum CdsLoggerGroups {
        security$authentication("com.sap.cds.framework.spring.config.auth", "com.sap.cds.feature.xsuaa", "com.sap.cds.feature.identity", "com.sap.cds.services.impl.runtime.mockusers", "com.sap.cloud.security"),
        security$authorization("com.sap.cds.services.impl.cds.AuthorizationHandler", "com.sap.cds.services.impl.authorization"),
        odata$v2("com.sap.cds.adapter.odata.v2"),
        odata$v4("com.sap.cds.adapter.odata.v4"),
        hcql("com.sap.cds.adapter.hcql"),
        auditlog("com.sap.cds.services.impl.auditlog", "com.sap.cds.feature.auditlog.v2", "com.sap.xs.audit.client"),
        messaging("com.sap.cds.services.impl.messaging", "com.sap.cds.services.messaging", "com.sap.cds.feature.messaging"),
        handlers("com.sap.cds.services.impl.ServiceImpl", "com.sap.cds.services.impl.request.RequestContextImpl", "com.sap.cds.services.impl.changeset.ChangeSetContextImpl"),
        persistence$sql("com.sap.cds.impl.JDBCClient", "com.sap.cds.impl.CdsDataStoreImpl"),
        persistence$sql_tx("org.springframework.transaction.support", "org.springframework.jdbc.datasource", "org.springframework.jdbc.support", "com.sap.cds.services.impl.changeset.ChangeSetContextImpl", "com.zaxxer.hikari", "org.apache.tomcat.jdbc.pool", "org.apache.tomcat.dbcp.dbcp2"),
        multitenancy("com.sap.cloud.mt", "com.sap.cds.mtx", "com.sap.cds.mt", "com.sap.cds.adapter.subscription", "com.sap.cds.services.mt", "com.sap.cds.feature.mt", "com.sap.cds.framework.spring.config.mt", "com.sap.cds.services.impl.model.DynamicModelProvider"),
        remote$odata("com.sap.cds.services.impl.odata"),
        remote$hcql("com.sap.cds.services.impl.hcql"),
        remote$rest("com.sap.cds.integration.cloudsdk.rest.client"),
        remote$wire("org.apache.http", "com.sap.cloud.sdk"),
        outbox("com.sap.cds.services.impl.outbox"),
        properties("com.sap.cds.services.impl.application.CdsPropertiesLogger");

        private static final String LOGGING_GROUP_PREFIX = "logging.group.com.sap.cds";
        private String[] loggers;

        private CdsLoggerGroups(String ... loggers) {
            this.loggers = loggers;
        }

        private String[] loggers() {
            return this.loggers;
        }

        private String[] loggerGroups() {
            String[] loggerGroups = this.name().replace('_', '-').split("\\$");
            StringBuffer name = new StringBuffer(LOGGING_GROUP_PREFIX);
            for (int i = 0; i < loggerGroups.length; ++i) {
                name.append(".").append(loggerGroups[i]);
                loggerGroups[i] = name.toString();
            }
            return loggerGroups;
        }
    }
}

