/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.framework.spring.config.auth;

import org.springframework.security.config.annotation.web.builders.HttpSecurity;

/**
 * A {@link HttpSecurityConfigurer}  configures the authentication of the endpoints
 * exposed by the registered Servlet adapters.
 * Service endpoints that require no authorization as defined in the CDS model are exposed as public.
 */
public interface HttpSecurityConfigurer {

	public void configure(HttpSecurity http) throws Exception; // NOSONAR

}


