/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.services.messages.LocalizedMessageProvider;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.StringUtils;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@AutoConfiguration
public class SpringLocalizedMessageProvider {
    private static final Logger logger = LoggerFactory.getLogger(SpringLocalizedMessageProvider.class);

    @Bean
    @Order(value=0x7FFFFFFF)
    public LocalizedMessageProvider localizedMessageProvider(final MessageSource messageSource) {
        return new LocalizedMessageProvider(){

            public String get(String messageOrKey, Object[] args, Locale locale) {
                try {
                    String message = messageSource.getMessage(messageOrKey, args, null, LocaleUtils.getLocaleForBundle((Locale)locale));
                    if (message != null) {
                        return message;
                    }
                    return MessageFormatter.arrayFormat((String)messageOrKey, (Object[])args).getMessage();
                }
                catch (Exception e) {
                    logger.warn("Invalid message format '{}' or incompatible arguments {}", new Object[]{messageOrKey, StringUtils.toStringSafely((Object[])args), e});
                    return messageOrKey;
                }
            }
        };
    }
}

