/*
 * © 2024-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.framework.spring.actuator;

import com.sap.cds.framework.spring.config.runtime.CdsRuntimeBeanDefinitionRegistrar;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.lib.mtx.impl.ModelProviderAccess;
import org.springframework.boot.actuate.autoconfigure.health.ConditionalOnEnabledHealthIndicator;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;

@AutoConfiguration(after = {CdsRuntimeBeanDefinitionRegistrar.class})
@ConditionalOnClass({HealthIndicator.class})
@ConditionalOnEnabledHealthIndicator("modelProvider")
@Conditional(ModelProviderEnabledCondition.class)
public class ModelProviderHealthIndicatorConfiguration {

  @Bean
  public HealthIndicator modelProviderHealthIndicator(CdsRuntime runtime) {
    return new DestinationBasedHealthIndicator(
        runtime, ModelProviderAccess.MODEL_PROVIDER_DESTINATION, "modelProvider");
  }
}
