/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.framework.spring.config.auth.identity;

import com.sap.cds.framework.spring.config.auth.identity.IdentityAotRuntimeHints.Hints;
import com.sap.cloud.security.spring.token.authentication.JavaSecurityContextHolderStrategy;
import java.util.List;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.security.core.context.SecurityContextHolder;

@AutoConfiguration
@ConditionalOnClass({
  JavaSecurityContextHolderStrategy.class,
  SecurityContextHolder.class
}) // spring-security
@ImportRuntimeHints(Hints.class)
public class IdentityAotRuntimeHints {

  static class Hints implements RuntimeHintsRegistrar {

    @Override
    public void registerHints(RuntimeHints hints, ClassLoader classLoader) {
      hints
          .reflection()
          .registerType(
              SecurityContextHolder.class,
              h ->
                  h.withMethod(
                      "setStrategyName",
                      List.of(TypeReference.of(String.class)),
                      ExecutableMode.INVOKE))
          .registerType(
              JavaSecurityContextHolderStrategy.class,
              (h) -> h.withConstructor(List.of(), ExecutableMode.INVOKE));
    }
  }
}
