/*
 * © 2022-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.framework.spring.config.datasource;

import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class DataSourceTransactionManagerBeanFactory
    implements FactoryBean<DataSourceTransactionManager>, BeanFactoryAware {

  private final String dataSourceName;
  private BeanFactory beanFactory;
  private DataSourceTransactionManager txMgr;

  public DataSourceTransactionManagerBeanFactory(String dataSourceName) {
    this.dataSourceName = dataSourceName;
  }

  @Override
  public DataSourceTransactionManager getObject() throws Exception {
    if (txMgr == null) {
      DataSource dataSource = beanFactory.getBean(dataSourceName, DataSource.class);
      txMgr = new DataSourceTransactionManager(dataSource);
    }
    return txMgr;
  }

  @Override
  public Class<?> getObjectType() {
    return DataSourceTransactionManager.class;
  }

  @Override
  public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    this.beanFactory = beanFactory;
  }
}
