/*
 * © 2022-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.framework.spring.config.mt;

import com.sap.cds.feature.mt.lib.runtime.TenantAwareDataSource;
import com.sap.cds.framework.spring.config.runtime.CdsRuntimeBeanDefinitionRegistrar;
import com.sap.cds.services.mt.impl.MtUnsubscriptionClearDatasourceHandler;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after = CdsRuntimeBeanDefinitionRegistrar.class)
@ConditionalOnClass(TenantAwareDataSource.class)
@ConditionalOnSingleCandidate(TenantAwareDataSource.class)
public class MtUnsubscriptionClearDatasourceHandlerConfig {

  @Bean
  public MtUnsubscriptionClearDatasourceHandler mtUnsubscriptionClearDatasourceHandler(
      TenantAwareDataSource dataSource) {
    return new MtUnsubscriptionClearDatasourceHandler(dataSource);
  }
}
