/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.sap.cds.services.Service;
import com.sap.cds.services.runtime.CdsRuntime;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;

public class ServiceBeanFactory implements FactoryBean<Service>, BeanFactoryAware {

  private final String serviceName;
  private final Class<?> serviceClass;
  private BeanFactory beanFactory;
  private Service service;

  public ServiceBeanFactory(String serviceName, Class<?> serviceClass) {
    this.serviceName = serviceName;
    this.serviceClass = serviceClass;
  }

  @Override
  public Service getObject() {
    if (service == null) {
      CdsRuntime runtime = beanFactory.getBean(CdsRuntime.class);
      service = runtime.getServiceCatalog().getService(serviceName);
    }
    return service;
  }

  @Override
  public Class<?> getObjectType() {
    return serviceClass == null ? Service.class : serviceClass;
  }

  @Override
  public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
    this.beanFactory = beanFactory;
  }
}
