/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.datasource;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.datasource.DataSourceDescriptor;
import com.sap.cds.services.utils.datasource.DataSourceUtils;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tomcat.jdbc.pool.DataSource;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.boot.context.properties.bind.BindResult;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;

public class DataSourceDescriptorBeanFactory
implements FactoryBean<javax.sql.DataSource>,
EnvironmentAware,
BeanFactoryAware {
    private static boolean isHikariEnabled = false;
    private static boolean isTomcatEnabled = false;
    private final String descriptorName;
    private Environment environment;
    private BeanFactory beanFactory;
    private javax.sql.DataSource dataSource;

    public DataSourceDescriptorBeanFactory(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    public javax.sql.DataSource getObject() throws Exception {
        if (this.dataSource == null) {
            BootstrapCache bootstrapCache = (BootstrapCache)this.beanFactory.getBean(BootstrapCache.class);
            DataSourceDescriptor descriptor = bootstrapCache.getDataSourceDescriptors().stream().filter(d -> d.getName().equals(this.descriptorName)).findFirst().orElseThrow(() -> new IllegalStateException());
            DataSourceBuilder builder = DataSourceBuilder.create();
            builder.driverClassName(descriptor.getDriverClassName());
            builder.url(descriptor.getUrl());
            if (!"x509".equalsIgnoreCase(descriptor.getCredentialType())) {
                builder.username(descriptor.getUsername());
                builder.password(descriptor.getPassword());
            }
            javax.sql.DataSource ds = builder.build();
            Binder binder = Binder.get((Environment)this.environment);
            Bindable bindableDs = Bindable.ofInstance((Object)ds);
            for (String section : DataSourceDescriptorBeanFactory.getDataSourceSections(descriptor.getName())) {
                BindResult bindResult = binder.bind(section, bindableDs);
                if (!bindResult.isBound()) continue;
                ds = (javax.sql.DataSource)bindResult.get();
                break;
            }
            if ("x509".equalsIgnoreCase(descriptor.getCredentialType())) {
                DataSourceDescriptorBeanFactory.configureX509(ds, descriptor.getPassword());
            }
            this.dataSource = ds;
        }
        return this.dataSource;
    }

    private static void configureX509(javax.sql.DataSource ds, String certAndKey) {
        Properties props = new Properties();
        props.setProperty("authenticationMethods", "X509");
        props.setProperty("authenticationX509", certAndKey);
        if (isHikariEnabled && ds instanceof HikariDataSource) {
            HikariDataSource hikari = (HikariDataSource)ds;
            hikari.setDataSourceProperties(props);
        } else if (isTomcatEnabled && ds instanceof DataSource) {
            DataSource tomcat = (DataSource)ds;
            tomcat.getDbProperties().putAll((Map<?, ?>)props);
        } else {
            throw new ServiceException("Unsupported DataSource type for X509: " + ds.getClass().getName(), new Object[0]);
        }
    }

    private static List<String> getDataSourceSections(String name) {
        return Arrays.asList(DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)DataSourceUtils.PoolType.HIKARI), DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)DataSourceUtils.PoolType.TOMCAT), DataSourceUtils.getDataSourceSection((String)name, (DataSourceUtils.PoolType)DataSourceUtils.PoolType.DBCP2));
    }

    public Class<?> getObjectType() {
        return javax.sql.DataSource.class;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    static {
        try {
            Class.forName("com.zaxxer.hikari.HikariDataSource");
            isHikariEnabled = true;
        }
        catch (ClassNotFoundException e) {
            isHikariEnabled = false;
        }
        try {
            Class.forName("org.apache.tomcat.jdbc.pool.DataSource");
            isTomcatEnabled = true;
        }
        catch (ClassNotFoundException e) {
            isTomcatEnabled = false;
        }
    }
}

