/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.auth;

import com.sap.cds.adapter.ServletUrlResourcePaths;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.framework.spring.config.auth.HttpSecurityConfigurer;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

@AutoConfiguration
@ConditionalOnClass(value={WebSecurityConfigurer.class})
public class CdsHttpSecurityConfigurerConfig {
    @Bean
    @ConditionalOnMissingBean
    public HttpSecurityConfigurer httpSecurityConfigurer(CdsRuntime runtime) {
        return new CdsModelBasedSecurityConfigurer(runtime);
    }

    public static RequestMatcher matcher(HttpMethod method, String path) {
        return AntPathRequestMatcher.antMatcher((HttpMethod)method, (String)path);
    }

    public static RequestMatcher matcher(String path) {
        return AntPathRequestMatcher.antMatcher((String)path);
    }

    private static class CdsModelBasedSecurityConfigurer
    implements HttpSecurityConfigurer {
        private static final Logger logger = LoggerFactory.getLogger(CdsModelBasedSecurityConfigurer.class);
        private final CdsRuntime runtime;

        public CdsModelBasedSecurityConfigurer(CdsRuntime runtime) {
            this.runtime = runtime;
        }

        @Override
        public void configure(HttpSecurity http) throws Exception {
            ServletUrlResourcePaths servletPaths = new ServletUrlResourcePaths(this.runtime);
            if (!this.runtime.getEnvironment().getCdsProperties().getSecurity().getAuthentication().isAuthenticateUnknownEndpoints()) {
                http.securityMatchers(matcher -> matcher.requestMatchers((RequestMatcher[])servletPaths.getBasePaths().map(UrlResourcePath::getPath).map(CdsHttpSecurityConfigurerConfig::matcher).toArray(RequestMatcher[]::new)));
                logger.info("Configuring authentication of CDS adapter endpoints. Other endpoints are not configured.");
            }
            final ArrayList publicPathMatchers = new ArrayList();
            http.authorizeHttpRequests(urlRegistry -> {
                servletPaths.visit(new ServletUrlResourcePaths.UrlResourcePathVisitor(){
                    final /* synthetic */ AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry val$urlRegistry;
                    {
                        this.val$urlRegistry = authorizationManagerRequestMatcherRegistry;
                    }

                    public void foundPublicPath(UrlResourcePath publicPath) {
                        publicPathMatchers.add(CdsHttpSecurityConfigurerConfig.matcher(publicPath.getPath()));
                        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)this.val$urlRegistry.requestMatchers(new RequestMatcher[]{CdsHttpSecurityConfigurerConfig.matcher(publicPath.getPath())})).permitAll();
                        logger.debug("Public CDS endpoint {}", (Object)publicPath.getPath());
                    }

                    public void foundPublicEvents(UrlResourcePath path, Stream<String> publicEvents) {
                        publicEvents.forEach(publicEvent -> {
                            publicPathMatchers.add(CdsHttpSecurityConfigurerConfig.matcher(HttpMethod.valueOf((String)publicEvent), path.getPath()));
                            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)this.val$urlRegistry.requestMatchers(new RequestMatcher[]{CdsHttpSecurityConfigurerConfig.matcher(HttpMethod.valueOf((String)publicEvent), path.getPath())})).permitAll();
                            logger.debug("Public CDS endpoint for method {} {}", publicEvent, (Object)path.getPath());
                        });
                        ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)this.val$urlRegistry.requestMatchers(new RequestMatcher[]{CdsHttpSecurityConfigurerConfig.matcher(path.getPath())})).authenticated();
                        logger.debug("Authenticate CDS endpoint {}", (Object)path.getPath());
                    }
                });
                ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)urlRegistry.anyRequest()).authenticated();
            });
            http.csrf(c -> c.ignoringRequestMatchers(publicPathMatchers.toArray(new RequestMatcher[0])));
        }
    }
}

