/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.datasource;

import com.sap.cds.framework.spring.config.runtime.SpringJdbcPersistenceServiceConfiguration;
import com.sap.cds.services.impl.persistence.JdbcPersistenceService;
import com.sap.cds.services.impl.persistence.JdbcPersistenceServiceConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;
import javax.sql.DataSource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.transaction.PlatformTransactionManager;

public class JdbcPersistenceServiceBeanFactory
implements SmartFactoryBean<JdbcPersistenceService>,
BeanFactoryAware {
    private final String serviceName;
    private final String dataSourceName;
    private final String txMgrName;
    private BeanFactory beanFactory;
    private JdbcPersistenceServiceConfiguration configuration;

    public JdbcPersistenceServiceBeanFactory(String serviceName, String dataSourceName, String txMgrName) {
        this.serviceName = serviceName;
        this.dataSourceName = dataSourceName;
        this.txMgrName = txMgrName;
    }

    public JdbcPersistenceService getObject() throws Exception {
        if (this.configuration == null) {
            DataSource dataSource = (DataSource)this.beanFactory.getBean(this.dataSourceName, DataSource.class);
            PlatformTransactionManager txMgr = (PlatformTransactionManager)this.beanFactory.getBean(this.txMgrName, PlatformTransactionManager.class);
            this.configuration = SpringJdbcPersistenceServiceConfiguration.createJdbcPersistenceServiceConfiguration(this.serviceName, dataSource, txMgr);
        }
        CdsRuntimeConfigurer configurer = (CdsRuntimeConfigurer)this.beanFactory.getBean(CdsRuntimeConfigurer.class);
        return this.configuration.createOrGetService(configurer);
    }

    public Class<?> getObjectType() {
        return JdbcPersistenceService.class;
    }

    public boolean isEagerInit() {
        return true;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

