/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.runtime;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.framework.spring.config.runtime.IndexPageLinkLoggerCondition;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.path.UrlPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.event.EventListener;

@AutoConfiguration
@ConditionalOnWebApplication
@Conditional(value={IndexPageLinkLoggerCondition.class})
public class IndexPageLinkLoggerConfiguration {
    private final Logger logger = LoggerFactory.getLogger(IndexPageLinkLoggerConfiguration.class);
    private final CdsRuntime runtime;

    public IndexPageLinkLoggerConfiguration(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    @EventListener
    public void onWebServerInitializedEvent(WebServerInitializedEvent event) {
        if (this.runtime.getEnvironment().getCdsProperties().getIndexPage().isEnabled().booleanValue()) {
            this.logger.info("CAP Index Page served at {}", (Object)this.prepareUrl(event));
        }
    }

    @VisibleForTesting
    protected String prepareUrl(WebServerInitializedEvent event) {
        CdsProperties.Servlet indexPageServlet = this.runtime.getEnvironment().getCdsProperties().getIndexPage();
        int port = event.getWebServer().getPort();
        String path = UrlPathUtil.normalizeBasePath((String)indexPageServlet.getPath());
        return "http://localhost:" + port + path;
    }
}

