/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.actuator;

import com.google.common.collect.Lists;
import com.sap.cds.adapter.ServletUrlResourcePaths;
import com.sap.cds.adapter.UrlResourcePath;
import com.sap.cds.framework.spring.config.auth.identity.IdentitySecurityConfig;
import com.sap.cds.framework.spring.config.auth.mock.MockUsersSecurityConfig;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.info.CdsInfo;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;

@AutoConfiguration
@ConditionalOnClass(value={WebSecurityConfigurer.class})
public class CdsSecurityInfo {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CdsRuntime cdsRuntime;

    public CdsSecurityInfo() {
        CdsSecurityInfoImpl.securityInfo = this;
    }

    private Authentication determineAuthentication() {
        return Stream.of(Authentication.values()).filter(e -> e.config != null && this.applicationContext.getBeanNamesForType(e.config).length > 0).findFirst().orElse(Authentication.CUSTOM);
    }

    private Map<String, Object> authentication() {
        final Authentication authentication = this.determineAuthentication();
        return new LinkedHashMap<String, Object>(){
            {
                this.put("name", authentication.name);
                if (authentication.type != null) {
                    this.put("type", authentication.type);
                }
                if (authentication.remark != null) {
                    this.put("remark", authentication.remark);
                }
                CdsProperties.Security security = CdsSecurityInfo.this.cdsRuntime.getEnvironment().getCdsProperties().getSecurity();
                this.put("authenticate-unknown-endpoints", security.getAuthentication().isAuthenticateUnknownEndpoints());
                this.put("authenticate-metadata-endpoints", security.getAuthentication().isAuthenticateMetadataEndpoints());
                this.put("mode", security.getAuthentication().getMode());
            }
        };
    }

    private Map<String, Object> authorization() {
        return new LinkedHashMap<String, Object>(){
            {
                CdsProperties.Security security = CdsSecurityInfo.this.cdsRuntime.getEnvironment().getCdsProperties().getSecurity();
                this.put("draft-protection", security.getAuthorization().getDraftProtection().isEnabled());
            }
        };
    }

    private Map<String, List<String>> publicEndpoints() {
        Authentication authentication = this.determineAuthentication();
        final LinkedHashMap<String, List<String>> result = new LinkedHashMap<String, List<String>>();
        if (authentication != Authentication.CUSTOM) {
            new ServletUrlResourcePaths(this.cdsRuntime).visit(new ServletUrlResourcePaths.UrlResourcePathVisitor(){

                public void foundPublicPath(UrlResourcePath publicPath) {
                    result.put(publicPath.getPath(), Lists.newArrayList((Object[])new String[]{"*"}));
                }

                public void foundPublicEvents(UrlResourcePath path, Stream<String> publicEvents) {
                    List publicEventList = publicEvents.collect(Collectors.toList());
                    if (!publicEventList.isEmpty()) {
                        result.put(path.getPath(), publicEventList);
                    }
                }
            });
        }
        return result;
    }

    public static class CdsSecurityInfoImpl
    implements CdsInfo {
        private static CdsSecurityInfo securityInfo;

        public Map<String, Object> info(final CdsInfo.Details details) {
            return new LinkedHashMap<String, Object>(){
                {
                    if (securityInfo != null) {
                        Map<String, List<String>> publicEndpoints;
                        this.put("authentication", securityInfo.authentication());
                        this.put("authorization", securityInfo.authorization());
                        if (details == CdsInfo.Details.HIGH && !(publicEndpoints = securityInfo.publicEndpoints()).isEmpty()) {
                            this.put("public CDS adapter endpoints", publicEndpoints);
                        }
                    } else {
                        this.put("authentication", new LinkedHashMap<String, Object>(){
                            {
                                this.put("name", "Not configured");
                                this.put("remark", "All endpoints are public!");
                            }
                        });
                    }
                }
            };
        }

        public String name() {
            return "security";
        }
    }

    static enum Authentication {
        CUSTOM("Custom", "<unknown>", "Make sure CDS adapter endpoints are secured accordingly", null),
        MOCK("Mock users", "Basic", "Not appropriate for productive usage!", MockUsersSecurityConfig.class),
        IDENTITY("Identity", "OAuth2", null, IdentitySecurityConfig.class);

        private final String name;
        private final String type;
        private final String remark;
        private final Class<?> config;

        private Authentication(String name, String type, String remark, Class<?> config) {
            this.name = name;
            this.type = type;
            this.remark = remark;
            this.config = config;
        }
    }
}

