/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.config.ui;

import com.sap.cds.framework.spring.config.runtime.BootstrapCache;
import com.sap.cds.services.runtime.CdsRuntime;
import java.io.File;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

class StaticUiCondition
implements Condition {
    private static String[] uiLocations = new String[]{"app", "../app"};

    StaticUiCondition() {
    }

    static boolean hasAppFolder() {
        return StaticUiCondition.getAppFolder() != null;
    }

    static String getAppFolder() {
        for (String uiLocation : uiLocations) {
            File folder = new File(uiLocation);
            if (!folder.exists() || !folder.isDirectory()) continue;
            return uiLocation;
        }
        return null;
    }

    public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
        CdsRuntime runtime = BootstrapCache.get(context.getEnvironment()).getCdsRuntime();
        return runtime.getEnvironment().getCdsProperties().getIndexPage().isEnabled() != false && StaticUiCondition.hasAppFolder();
    }
}

