/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.actuator;

import com.sap.cds.services.utils.info.CdsInfo;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.management.JMX;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class CdsDbPoolsInfo
implements CdsInfo {
    public String name() {
        return "dbpools";
    }

    public Object info(CdsInfo.Details details) {
        Set<Object> names;
        LinkedHashMap info = new LinkedHashMap();
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            names = mBeanServer.queryNames(new ObjectName("com.zaxxer.hikari:type=Pool (*)"), null);
        }
        catch (MalformedObjectNameException e) {
            names = Collections.emptySet();
        }
        for (ObjectName name : names) {
            String poolName = name.getCanonicalName().substring(29, name.getCanonicalName().length() - 1);
            HikariPoolMXBean pool = JMX.newMXBeanProxy(mBeanServer, name, HikariPoolMXBean.class);
            LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
            try {
                props.put("tenantId", poolName.substring(11, poolName.indexOf("#")));
                props.put("databaseId", poolName.substring(poolName.indexOf("#") + 1, poolName.length()));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
            props.put("active", pool.getActiveConnections());
            props.put("idle", pool.getIdleConnections());
            props.put("total", pool.getTotalConnections());
            props.put("threadsAwaiting", pool.getThreadsAwaitingConnection());
            info.put(poolName, props);
        }
        return info;
    }
}

