/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.framework.spring.http.converter;

import com.sap.cds.CdsData;
import com.sap.cds.CdsJsonConverter;
import com.sap.cds.CdsJsonConverterException;
import com.sap.cds.ql.CdsName;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.SmartHttpMessageConverter;

public class CdsMessageConverter
implements SmartHttpMessageConverter<Object> {
    private final CdsJsonConverter converter;
    private final CdsModel cdsModel;

    public CdsMessageConverter(CdsModel model) {
        this.cdsModel = model;
        this.converter = (CdsJsonConverter)CdsJsonConverter.builder((CdsModel)this.cdsModel).unknownPropertyHandling(CdsJsonConverter.UnknownPropertyHandling.REJECT).build();
    }

    public List<MediaType> getSupportedMediaTypes() {
        return List.of(MediaType.APPLICATION_JSON);
    }

    public boolean canRead(ResolvableType type, MediaType mediaType) {
        if (mediaType != null && !MediaType.APPLICATION_JSON.isCompatibleWith(mediaType)) {
            return false;
        }
        Class<?> valueClass = this.retrieveValueClass(type);
        return this.canHandleType(valueClass);
    }

    public Object read(ResolvableType type, HttpInputMessage inputMessage, Map<String, Object> hints) throws IOException, HttpMessageNotReadableException {
        String json = new String(inputMessage.getBody().readAllBytes(), StandardCharsets.UTF_8);
        Class<?> valueClass = this.retrieveValueClass(type);
        try {
            if (this.isCollection(type)) {
                return this.converter.fromJsonArray(json, valueClass);
            }
            return this.converter.fromJsonObject(json, valueClass);
        }
        catch (CdsJsonConverterException e) {
            throw new HttpMessageNotReadableException("Failed to read CDS data", (Throwable)e, inputMessage);
        }
    }

    public boolean canWrite(ResolvableType targetType, Class<?> valueClass, MediaType mediaType) {
        return this.canRead(targetType, mediaType);
    }

    public void write(Object cdsData, ResolvableType type, MediaType contentType, HttpOutputMessage outputMessage, Map<String, Object> hints) throws IOException, HttpMessageNotWritableException {
        if (this.isCollection(cdsData)) {
            List list = ((Collection)cdsData).stream().toList();
            outputMessage.getBody().write(this.converter.toJson(list).getBytes(StandardCharsets.UTF_8));
        } else {
            outputMessage.getBody().write(this.converter.toJson((Map)((CdsData)cdsData)).getBytes(StandardCharsets.UTF_8));
        }
    }

    private boolean isCollection(Object cdsData) {
        return cdsData instanceof Collection;
    }

    private boolean isCollection(ResolvableType type) {
        Class rawClass = type.getRawClass();
        return rawClass != null && Collection.class.isAssignableFrom(rawClass) && type.hasGenerics();
    }

    private Class<?> retrieveValueClass(ResolvableType type) {
        Class rawClass = type.getRawClass();
        if (this.isCollection(type)) {
            ResolvableType genericType = type.getGeneric(new int[]{0});
            return genericType.getRawClass();
        }
        return rawClass;
    }

    private boolean canHandleType(Class<?> clazz) {
        if (clazz != null && CdsData.class.isAssignableFrom(clazz)) {
            return this.lookupCdsType(clazz.getAnnotation(CdsName.class)).isPresent();
        }
        return false;
    }

    private Optional<CdsStructuredType> lookupCdsType(CdsName cdsName) {
        if (cdsName != null) {
            return this.cdsModel.findStructuredType(cdsName.value());
        }
        return Optional.empty();
    }
}

