/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.handler;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.feature.platform.PlatformEnvironment;
import com.sap.cds.feature.platform.ServiceBinding;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class CloudplatformEnvironmentHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(CloudplatformEnvironmentHandler.class);

    @Before(event={"APPLICATION_PREPARED"})
    public void registerEnvironmentHandler() {
        CloudPlatformAccessor.tryGetCloudPlatform().andThen(platform -> platform.setEnvironmentVariableReader((Function)new CdsEnvironmentVariableReader(PlatformEnvironment.INSTANCE)));
    }

    static class CdsEnvironmentVariableReader
    implements Function<String, String> {
        private String vcapServices = null;

        public CdsEnvironmentVariableReader(PlatformEnvironment platformEnvironment) {
            List bindings = platformEnvironment.getServiceBindings().collect(Collectors.toList());
            HashMap<String, ArrayList<Map<String, Object>>> serviceToBinding = new HashMap<String, ArrayList<Map<String, Object>>>();
            for (ServiceBinding binding : bindings) {
                ArrayList<Map<String, Object>> service = (ArrayList<Map<String, Object>>)serviceToBinding.get(binding.getService());
                if (service == null) {
                    service = new ArrayList<Map<String, Object>>();
                    serviceToBinding.put(binding.getService(), service);
                }
                service.add(this.asMap(binding));
            }
            try {
                this.vcapServices = new ObjectMapper().writeValueAsString(serviceToBinding);
            }
            catch (JsonProcessingException e) {
                logger.warn("Could not serialize service bindings to JSON", (Throwable)e);
            }
        }

        private Map<String, Object> asMap(ServiceBinding binding) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", binding.getName());
            map.put("label", binding.getService());
            map.put("plan", binding.getServicePlan());
            map.put("tags", binding.getTags());
            map.put("credentials", binding.getCredentials());
            return map;
        }

        @Override
        public String apply(String name) {
            if (name.equals("VCAP_SERVICES")) {
                return this.vcapServices;
            }
            return System.getenv(name);
        }
    }
}

