/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.handler;

import java.util.concurrent.Callable;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import com.sap.cloud.sdk.frameworks.resilience4j.GenericDecorator;
import com.sap.cloud.sdk.frameworks.resilience4j.Resilience4jDecorationStrategy;

@ServiceName(ApplicationLifecycleService.DEFAULT_NAME)
public class ResilienceThreadContextHandler implements EventHandler {

	@Before
	public void registerResilienceThreadContextDecorator(ApplicationPreparedEventContext context) {
		CdsRuntime runtime = context.getCdsRuntime();
		GenericDecorator customDecorator = new GenericDecorator() {

			@Override
			public <T> Callable<T> decorateCallable(Callable<T> callable, ResilienceConfiguration configuration) {
				// TODO what about Spring Security Context?
				// TODO what about ChangeSet -> how about Spring transactions?
				RequestContextRunner runner = runtime.requestContext();
				return () -> {
					return runner.run((context) -> {
						try {
							return callable.call();
						} catch (RuntimeException e) { // NOSONAR
							throw e;
						} catch (Exception e) {
							throw new RuntimeException(e); // NOSONAR
						}
					});
				};
			}

		};

		ResilienceDecorator.setDecorationStrategy(Resilience4jDecorationStrategy.builder().decorator(customDecorator).defaultDecorators().build());
	}

}
