/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.handler;

import com.sap.cds.integration.cloudsdk.facade.CdsPrincipalFacade;
import com.sap.cds.integration.cloudsdk.facade.CdsTenantFacade;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;

@ServiceName(ApplicationLifecycleService.DEFAULT_NAME)
public class FacadeRegistrationHandler implements EventHandler {

	@Before
	public void registerFacades(ApplicationPreparedEventContext context) {
		TenantAccessor.setTenantFacade(new CdsTenantFacade(context.getCdsRuntime()));
		PrincipalAccessor.setPrincipalFacade(new CdsPrincipalFacade(context.getCdsRuntime()));
	}

}
