/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.services.runtime.CdsRuntimeConfiguration;
import com.sap.cds.services.runtime.CdsRuntimeConfigurer;

public class CloudSdkHandlerConfiguration implements CdsRuntimeConfiguration {

	private static final Logger log = LoggerFactory.getLogger(CloudSdkHandlerConfiguration.class);

	@Override
	public void eventHandlers(CdsRuntimeConfigurer configurer) {
		configurer.eventHandler(new CloudplatformEnvironmentHandler())
			.eventHandler(new FacadeRegistrationHandler());

		try {
			getClass().getClassLoader().loadClass("com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutorService");
			log.debug("Found Cloud SDK 4 executor service, not adding legacy resilience decorator.");
		} catch (ClassNotFoundException e) {
			log.warn("Could not find Cloud SDK 4 executor service class on the classpath. Adding legacy resilience decorator for compatibility.");
			configurer.eventHandler(new ResilienceThreadContextHandler());
		}

	}
}
