/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.handler;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sap.cds.integration.cloudsdk.decorator.CdsThreadContextDecorator;
import com.sap.cds.integration.cloudsdk.facade.CdsPrincipalFacade;
import com.sap.cds.integration.cloudsdk.facade.CdsTenantFacade;
import com.sap.cds.integration.cloudsdk.facade.CdsRequestHeaderFacade;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderAccessor;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContextDecoratorChain;

@ServiceName(ApplicationLifecycleService.DEFAULT_NAME)
public class FacadeRegistrationHandler implements EventHandler {

	private static final Logger log = LoggerFactory.getLogger(FacadeRegistrationHandler.class);

	@Before
	public void registerFacades(ApplicationPreparedEventContext context) {
		TenantAccessor.setTenantFacade(new CdsTenantFacade(context.getCdsRuntime()));
		PrincipalAccessor.setPrincipalFacade(new CdsPrincipalFacade(context.getCdsRuntime()));
		RequestHeaderAccessor.setHeaderFacade(new CdsRequestHeaderFacade(context.getCdsRuntime()));

		try {
			getClass().getClassLoader().loadClass("com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutorService");
			log.debug("Found Cloud SDK 4 executor service, adding a {} to pass on the CDS RequestContext.", CdsThreadContextDecorator.class.getSimpleName());
			DefaultThreadContextDecoratorChain.registerDefaultDecorator(new CdsThreadContextDecorator(context.getCdsRuntime()));
		} catch (ClassNotFoundException e) {
			log.warn("Could not find Cloud SDK 4 executor service class on the classpath. Automated propagation of CDS RequestContext not available.");
		}
	}
}
