/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.handler;

import com.sap.cds.integration.cloudsdk.decorator.CdsThreadContextDecorator;
import com.sap.cds.integration.cloudsdk.facade.CdsPrincipalFacade;
import com.sap.cds.integration.cloudsdk.facade.CdsRequestHeaderFacade;
import com.sap.cds.integration.cloudsdk.facade.CdsTenantFacade;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderAccessor;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderFacade;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAccessor;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalFacade;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantFacade;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContextDecoratorChain;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class FacadeRegistrationHandler
implements EventHandler {
    private static final Logger log = LoggerFactory.getLogger(FacadeRegistrationHandler.class);

    @Before
    public void registerFacades(ApplicationPreparedEventContext context) {
        TenantAccessor.setTenantFacade((TenantFacade)new CdsTenantFacade(context.getCdsRuntime()));
        PrincipalAccessor.setPrincipalFacade((PrincipalFacade)new CdsPrincipalFacade(context.getCdsRuntime()));
        RequestHeaderAccessor.setHeaderFacade((RequestHeaderFacade)new CdsRequestHeaderFacade(context.getCdsRuntime()));
        try {
            this.getClass().getClassLoader().loadClass("com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutorService");
            log.debug("Found Cloud SDK 4 executor service, adding a {} to pass on the CDS RequestContext.", (Object)CdsThreadContextDecorator.class.getSimpleName());
            DefaultThreadContextDecoratorChain.registerDefaultDecorator((ThreadContextDecorator)new CdsThreadContextDecorator(context.getCdsRuntime()));
        }
        catch (ClassNotFoundException e) {
            log.warn("Could not find Cloud SDK 4 executor service class on the classpath. Automated propagation of CDS RequestContext not available.");
        }
    }
}

