/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.handler;

import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.RequestContextRunner;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorationStrategy;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import com.sap.cloud.sdk.frameworks.resilience4j.GenericDecorator;
import com.sap.cloud.sdk.frameworks.resilience4j.Resilience4jDecorationStrategy;
import java.util.concurrent.Callable;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class ResilienceThreadContextHandler
implements EventHandler {
    @Before
    public void registerResilienceThreadContextDecorator(ApplicationPreparedEventContext context) {
        final CdsRuntime runtime = context.getCdsRuntime();
        GenericDecorator customDecorator = new GenericDecorator(){

            public <T> Callable<T> decorateCallable(Callable<T> callable, ResilienceConfiguration configuration) {
                RequestContextRunner runner = runtime.requestContext();
                return () -> runner.run(context -> {
                    try {
                        return callable.call();
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
            }
        };
        ResilienceDecorator.setDecorationStrategy((ResilienceDecorationStrategy)Resilience4jDecorationStrategy.builder().decorator(customDecorator).defaultDecorators().build());
    }
}

