/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.handler;

import com.sap.cds.integration.cloudsdk.decorator.CdsThreadContextDecorator;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorationStrategy;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceDecorator;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContextDecoratorChain;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextDecorator;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutorService;
import com.sap.cloud.sdk.frameworks.resilience4j.GenericDecorator;
import com.sap.cloud.sdk.frameworks.resilience4j.Resilience4jDecorationStrategy;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServiceName(value={"ApplicationLifecycleService$Default"})
public class ThreadContextHandler
implements EventHandler {
    private static final Logger logger = LoggerFactory.getLogger(ThreadContextHandler.class);
    private static boolean cloudSDK4Available;

    @Before
    public void registerDecorators(ApplicationPreparedEventContext context) {
        if (cloudSDK4Available) {
            logger.debug("Found Cloud SDK 4 executor service, adding {}", (Object)CdsThreadContextDecorator.class.getSimpleName());
            this.registerThreadContextDecorator(context);
        } else {
            logger.debug("Could not find Cloud SDK 4 executor service on the classpath. Automated propagation of RequestContext only available for resilience features.");
            this.registerResilienceThreadContextDecoratorForCompatibility(context);
        }
    }

    private void registerThreadContextDecorator(ApplicationPreparedEventContext context) {
        DefaultThreadContextDecoratorChain.registerDefaultDecorator((ThreadContextDecorator)new CdsThreadContextDecorator(context.getCdsRuntime()));
    }

    private void registerResilienceThreadContextDecoratorForCompatibility(final ApplicationPreparedEventContext context) {
        GenericDecorator customDecorator = new GenericDecorator(){
            private final CdsThreadContextDecorator decorator;
            {
                this.decorator = new CdsThreadContextDecorator(context.getCdsRuntime());
            }

            public <T> Callable<T> decorateCallable(Callable<T> callable, ResilienceConfiguration configuration) {
                return this.decorator.decorateCallable(callable);
            }
        };
        ResilienceDecorator.setDecorationStrategy((ResilienceDecorationStrategy)Resilience4jDecorationStrategy.builder().decorator(customDecorator).defaultDecorators().build());
    }

    static {
        try {
            cloudSDK4Available = ThreadContextExecutorService.class.getName() != null;
        }
        catch (NoClassDefFoundError e) {
            cloudSDK4Available = false;
        }
    }
}

