/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.handler;

import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ApplicationPreparedEventContext;
import com.sap.cds.services.handler.EventHandler;
import com.sap.cds.services.handler.annotations.Before;
import com.sap.cds.services.handler.annotations.ServiceName;
import com.sap.cds.services.utils.environment.CdsEnvironmentVariableReader;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;

@ServiceName(ApplicationLifecycleService.DEFAULT_NAME)
public class CloudplatformEnvironmentHandler implements EventHandler {

	@Before
	public void registerEnvironmentHandler(ApplicationPreparedEventContext context) {
		CloudPlatformAccessor.tryGetCloudPlatform().andThen((platform) -> {
			platform.setEnvironmentVariableReader(new CdsEnvironmentVariableReader(context.getCdsRuntime().getEnvironment().getServiceBindings()));
		});
	}

}
