/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.rest.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sap.cds.integration.cloudsdk.destination.DestinationResolver;
import com.sap.cds.integration.cloudsdk.rest.client.JsonRestClientResponseException;
import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestDeniedException;
import com.sap.cloud.sdk.cloudplatform.security.exception.TokenRequestFailedException;
import java.io.IOException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRestClient {
    private static final Logger logger = LoggerFactory.getLogger(JsonRestClient.class);
    private static final String UTF_8 = "UTF-8";
    private static final String JSON_CONTENT = "application/json";
    private static final String CONTENT_TYPE = "content-type";
    protected final ObjectMapper mapper = new ObjectMapper();
    private final String apiUrl;
    private final CloseableHttpClient client;

    public JsonRestClient(String apiUrl, ServiceBinding binding, OnBehalfOf onBehalfOf) {
        this(apiUrl, binding, 60000L, 20, 2, onBehalfOf);
    }

    public JsonRestClient(String apiUrl, ServiceBinding binding, long timeoutMillis, int maxConnections, int maxConnectionPerRoute, OnBehalfOf onBehalfOf) {
        this.apiUrl = apiUrl;
        DefaultHttpClientFactory.DefaultHttpClientFactoryBuilder builder = DefaultHttpClientFactory.builder();
        builder.timeoutMilliseconds((int)timeoutMillis);
        builder.maxConnectionsPerRoute(maxConnectionPerRoute);
        builder.maxConnectionsTotal(maxConnections);
        DefaultHttpClientFactory httpClientFactory = builder.build();
        HttpDestination dest = DestinationResolver.getDestinationForXsuaaBasedServiceBinding(apiUrl, binding, onBehalfOf);
        this.client = (CloseableHttpClient)httpClientFactory.createHttpClient((HttpDestinationProperties)dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode getRequest(String path) throws IOException {
        HttpGet get = new HttpGet(this.getUrl(path));
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)get));
            return jsonNode;
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * Loose catch block
     */
    public int getRequestWithOnlyResponseCode(String path) throws IOException {
        HttpGet get = new HttpGet(this.getUrl(path));
        try {
            try (CloseableHttpResponse response = this.handleRequest((HttpRequestBase)get);){
                int n = response.getStatusLine().getStatusCode();
                return n;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode deleteRequest(String path) throws IOException {
        HttpDelete del = new HttpDelete(this.getUrl(path));
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)del));
            return jsonNode;
        }
        finally {
            del.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode putRequest(String path, JsonNode data) throws IOException {
        HttpPut put = new HttpPut(this.getUrl(path));
        if (data != null) {
            put.setEntity((HttpEntity)new StringEntity(this.mapper.writer().writeValueAsString((Object)data), UTF_8));
        }
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)put));
            return jsonNode;
        }
        finally {
            put.releaseConnection();
        }
    }

    public JsonNode postRequest(String path, JsonNode data) throws IOException {
        String strData = this.mapper.writer().writeValueAsString((Object)data);
        return this.postRequest(path, strData, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonNode postRequest(String path, String data, Map<String, String> headers) throws IOException {
        HttpPost post = new HttpPost(this.getUrl(path));
        if (headers != null) {
            headers.forEach((arg_0, arg_1) -> ((HttpPost)post).setHeader(arg_0, arg_1));
        }
        if (data != null) {
            post.setEntity((HttpEntity)new StringEntity(data, UTF_8));
        }
        try {
            JsonNode jsonNode = this.handleJsonResponse(this.handleRequest((HttpRequestBase)post));
            return jsonNode;
        }
        finally {
            post.releaseConnection();
        }
    }

    private CloseableHttpResponse handleRequest(HttpRequestBase request) throws IOException {
        this.setHeaders((HttpRequest)request);
        try {
            return this.client.execute((HttpUriRequest)request);
        }
        catch (TokenRequestDeniedException e) {
            throw new JsonRestClientResponseException(401, "Authentication invalid: " + e.getMessage());
        }
        catch (TokenRequestFailedException e) {
            throw new JsonRestClientResponseException(401, "Authentication failed: " + e.getMessage());
        }
    }

    private void setHeaders(HttpRequest request) {
        logger.debug("Creating {} request to {}", (Object)request.getRequestLine().getMethod(), (Object)request.getRequestLine().getUri());
        request.removeHeaders(CONTENT_TYPE);
        request.addHeader(CONTENT_TYPE, JSON_CONTENT);
    }

    private JsonNode handleJsonResponse(CloseableHttpResponse response) throws IOException {
        Throwable throwable = null;
        try (CloseableHttpResponse resp = response;){
            int code = resp.getStatusLine().getStatusCode();
            logger.debug("Responded with status code '{}'", (Object)code);
            if (code >= 200 && code <= 207) {
                String contentType = JSON_CONTENT;
                if (resp.getEntity() != null) {
                    if (resp.getEntity().getContentType() != null) {
                        contentType = resp.getEntity().getContentType().getValue();
                    }
                    if (contentType.contains(JSON_CONTENT)) {
                        String jsonData = EntityUtils.toString((HttpEntity)resp.getEntity());
                        JsonNode jsonNode = (JsonNode)this.mapper.readValue(jsonData, JsonNode.class);
                        return jsonNode;
                    }
                    throw new IOException("Unexpected response format: Expected JSON but found '" + contentType + "'");
                }
                JsonNode jsonNode = (JsonNode)this.mapper.readValue("{}", JsonNode.class);
                return jsonNode;
            }
            try {
                String reason = resp.getStatusLine().getReasonPhrase();
                throw new JsonRestClientResponseException(code, "Unexpected request HTTP response (" + code + ") " + reason);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private String getUrl(String path) {
        return this.apiUrl + path;
    }
}

