/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.destination;

import com.sap.cds.services.environment.ServiceBinding;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.OAuth2DestinationBuilder;
import com.sap.cloud.sdk.cloudplatform.connectivity.OnBehalfOf;
import com.sap.cloud.security.config.ClientCertificate;
import com.sap.cloud.security.config.ClientCredentials;
import com.sap.cloud.security.config.ClientIdentity;
import java.util.Map;

public class DestinationResolver {
    private DestinationResolver() {
    }

    public static HttpDestination getDestinationForXsuaaBasedServiceBinding(String endpointUrl, ServiceBinding binding, OnBehalfOf onBehalfOf) {
        String tokenUrl;
        ClientCredentials client;
        Map credentials = binding.getCredentials();
        Map uaa = (Map)credentials.get("uaa");
        if ("x509".equals(uaa.get("credential-type"))) {
            client = new ClientCertificate((String)uaa.get("certificate"), (String)uaa.get("key"), (String)uaa.get("clientid"));
            tokenUrl = (String)uaa.get("certurl");
        } else {
            client = new ClientCredentials((String)uaa.get("clientid"), (String)uaa.get("clientsecret"));
            tokenUrl = (String)uaa.get("url");
        }
        return OAuth2DestinationBuilder.forTargetUrl((String)endpointUrl).withTokenEndpoint(tokenUrl).withClient((ClientIdentity)client, onBehalfOf).build();
    }
}

