/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.integration.cloudsdk.destination;

import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cloud.sdk.cloudplatform.connectivity.DefaultHttpClientFactory;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import java.util.function.Supplier;
import org.apache.http.client.HttpClient;

public class HttpClientProvider
implements Supplier<HttpClient> {
    private final TenantAwareCache<HttpClient, Boolean> clientCache;

    public HttpClientProvider(Supplier<HttpDestination> destinationSupplier, CdsProperties.ConnectionPool config, CdsRuntime runtime) {
        DefaultHttpClientFactory.DefaultHttpClientFactoryBuilder builder = DefaultHttpClientFactory.builder();
        builder.timeoutMilliseconds((int)config.getTimeout().toMillis());
        builder.maxConnectionsPerRoute(config.getMaxConnectionsPerRoute().intValue());
        builder.maxConnectionsTotal(config.getMaxConnections().intValue());
        DefaultHttpClientFactory factory = builder.build();
        Supplier<String> tenantSupplier = config.getCombinePools().isEnabled() != false ? () -> "global-pool" : () -> RequestContext.isActive() ? RequestContext.getCurrent((CdsRuntime)runtime).getUserInfo().getTenant() : runtime.getProvidedUserInfo().getTenant();
        this.clientCache = TenantAwareCache.create(tenantSupplier, () -> factory.createHttpClient((HttpDestinationProperties)destinationSupplier.get()), () -> true);
    }

    @Override
    public HttpClient get() {
        return (HttpClient)this.clientCache.findOrCreate();
    }
}

