/**************************************************************************
 * (C) 2019-2020 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.integration.cloudsdk.facade;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cloud.sdk.cloudplatform.security.Authorization;
import com.sap.cloud.sdk.cloudplatform.security.Scope;
import com.sap.cloud.sdk.cloudplatform.security.principal.CollectionPrincipalAttribute;
import com.sap.cloud.sdk.cloudplatform.security.principal.DefaultPrincipal;
import com.sap.cloud.sdk.cloudplatform.security.principal.Principal;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalAttribute;
import com.sap.cloud.sdk.cloudplatform.security.principal.PrincipalFacade;

import io.vavr.control.Try;

public class CdsPrincipalFacade implements PrincipalFacade {

	private final CdsRuntime runtime;

	public CdsPrincipalFacade(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public Try<Principal> tryGetCurrentPrincipal() {
		UserInfo userInfo = RequestContext.getCurrent(runtime).getUserInfo();
		String principalId = userInfo.getName(); // must not be null
		Set<Authorization> roles = userInfo.getRoles().stream().map(Scope::new).collect(Collectors.toSet());
		Map<String, PrincipalAttribute> attributes = new HashMap<>();
		userInfo.getAttributes().entrySet()
			.forEach((e) -> attributes.put(e.getKey(), new CollectionPrincipalAttribute<>(e.getKey(), e.getValue())));

		Principal principal = new DefaultPrincipal(principalId, roles, attributes);
		return Try.success(principal);
	}

}
